/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.basics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.basics.ReplacementRegistry;
import thetadev.constructionwand.containers.ContainerManager;
import thetadev.constructionwand.items.wand.ItemWand;
import thetadev.constructionwand.wand.WandItemUseContext;

public class WandUtil {
    public static boolean stackEquals(ItemStack stackA, ItemStack stackB) {
        return ItemStack.m_150942_((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean stackEquals(ItemStack stackA, Item item) {
        ItemStack stackB = new ItemStack((ItemLike)item);
        return WandUtil.stackEquals(stackA, stackB);
    }

    public static ItemStack holdingWand(Player player) {
        if (player.m_21120_(InteractionHand.MAIN_HAND) != ItemStack.f_41583_ && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ItemWand) {
            return player.m_21120_(InteractionHand.MAIN_HAND);
        }
        if (player.m_21120_(InteractionHand.OFF_HAND) != ItemStack.f_41583_ && player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ItemWand) {
            return player.m_21120_(InteractionHand.OFF_HAND);
        }
        return null;
    }

    public static BlockPos playerPos(Player player) {
        return new BlockPos(player.m_20182_());
    }

    public static Vec3 entityPositionVec(Entity entity) {
        return new Vec3(entity.m_20185_(), entity.m_20186_() - entity.m_6049_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_());
    }

    public static Vec3 blockPosVec(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static List<ItemStack> getHotbar(Player player) {
        return player.m_150109_().f_35974_.subList(0, 9);
    }

    public static List<ItemStack> getHotbarWithOffhand(Player player) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>(player.m_150109_().f_35974_.subList(0, 9));
        inventory.addAll((Collection<ItemStack>)player.m_150109_().f_35976_);
        return inventory;
    }

    public static List<ItemStack> getMainInv(Player player) {
        return player.m_150109_().f_35974_.subList(9, player.m_150109_().f_35974_.size());
    }

    public static List<ItemStack> getFullInv(Player player) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>((Collection<ItemStack>)player.m_150109_().f_35976_);
        inventory.addAll((Collection<ItemStack>)player.m_150109_().f_35974_);
        return inventory;
    }

    public static int blockDistance(BlockPos p1, BlockPos p2) {
        return Math.max(Math.abs(p1.m_123341_() - p2.m_123341_()), Math.abs(p1.m_123343_() - p2.m_123343_()));
    }

    public static boolean isTEAllowed(BlockState state) {
        if (!state.m_155947_()) {
            return true;
        }
        ResourceLocation name = state.m_60734_().getRegistryName();
        if (name == null) {
            return false;
        }
        String fullId = name.toString();
        String modId = name.m_135827_();
        boolean inList = ((List)ConfigServer.TE_LIST.get()).contains(fullId) || ((List)ConfigServer.TE_LIST.get()).contains(modId);
        boolean isWhitelist = (Boolean)ConfigServer.TE_WHITELIST.get();
        return isWhitelist == inList;
    }

    public static boolean placeBlock(Level world, Player player, BlockState block, BlockPos pos, @Nullable BlockItem item) {
        ItemStack stack;
        if (!world.m_46597_(pos, block)) {
            ConstructionWand.LOGGER.info("Block could not be placed");
            return false;
        }
        BlockSnapshot snapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos);
        BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(snapshot, block, (Entity)player);
        MinecraftForge.EVENT_BUS.post((Event)placeEvent);
        if (placeEvent.isCanceled()) {
            world.m_7471_(pos, false);
            return false;
        }
        if (item == null) {
            stack = new ItemStack((ItemLike)block.m_60734_().m_5456_());
        } else {
            stack = new ItemStack((ItemLike)item);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
        }
        block.m_60734_().m_6402_(world, pos, block, (LivingEntity)player, stack);
        return true;
    }

    public static boolean removeBlock(Level world, Player player, @Nullable BlockState block, BlockPos pos) {
        BlockState currentBlock = world.m_8055_(pos);
        if (!world.m_7966_(player, pos)) {
            return false;
        }
        if (!player.m_7500_()) {
            if (currentBlock.m_60800_((BlockGetter)world, pos) <= -1.0f || world.m_7702_(pos) != null) {
                return false;
            }
            if (block != null && !ReplacementRegistry.matchBlocks(currentBlock.m_60734_(), block.m_60734_())) {
                return false;
            }
        }
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(world, pos, currentBlock, player);
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        world.m_7471_(pos, false);
        return true;
    }

    public static int countItem(Player player, Item item) {
        if (player.m_150109_().f_35974_ == null) {
            return 0;
        }
        if (player.m_7500_()) {
            return Integer.MAX_VALUE;
        }
        int total = 0;
        ContainerManager containerManager = ConstructionWand.instance.containerManager;
        List<ItemStack> inventory = WandUtil.getFullInv(player);
        for (ItemStack stack : inventory) {
            if (stack == null || stack.m_41619_()) continue;
            if (WandUtil.stackEquals(stack, item)) {
                total += stack.m_41613_();
                continue;
            }
            int amount = containerManager.countItems(player, new ItemStack((ItemLike)item), stack);
            if (amount == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            total += amount;
        }
        return total;
    }

    private static boolean isPositionModifiable(Level world, Player player, BlockPos pos) {
        if (!world.m_46739_(pos)) {
            return false;
        }
        if (!world.m_7966_(player, pos)) {
            return false;
        }
        return (Integer)ConfigServer.MAX_RANGE.get() <= 0 || WandUtil.blockDistance(player.m_142538_(), pos) <= (Integer)ConfigServer.MAX_RANGE.get();
    }

    public static boolean isPositionPlaceable(Level world, Player player, BlockPos pos, boolean replace) {
        if (!WandUtil.isPositionModifiable(world, player, pos)) {
            return false;
        }
        if (world.m_46859_(pos)) {
            return true;
        }
        return replace && world.m_8055_(pos).m_60629_((BlockPlaceContext)new WandItemUseContext(world, player, new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.DOWN, pos, false), pos, (BlockItem)Items.f_41905_));
    }

    public static boolean isBlockRemovable(Level world, Player player, BlockPos pos) {
        if (!WandUtil.isPositionModifiable(world, player, pos)) {
            return false;
        }
        if (!player.m_7500_()) {
            return !(world.m_8055_(pos).m_60800_((BlockGetter)world, pos) <= -1.0f) && world.m_7702_(pos) == null;
        }
        return true;
    }

    public static boolean isBlockPermeable(Level world, BlockPos pos) {
        return world.m_46859_(pos) || world.m_8055_(pos).m_60812_((BlockGetter)world, pos).m_83281_();
    }

    public static boolean entitiesCollidingWithBlock(Level world, BlockState blockState, BlockPos pos) {
        VoxelShape shape = blockState.m_60812_((BlockGetter)world, pos);
        if (!shape.m_83281_()) {
            AABB blockBB = shape.m_83215_().m_82338_(pos);
            return !world.m_6443_(LivingEntity.class, blockBB, Predicate.not(Entity::m_5833_)).isEmpty();
        }
        return false;
    }

    public static Direction fromVector(Vec3 vector) {
        return Direction.m_122366_((double)vector.f_82479_, (double)vector.f_82480_, (double)vector.f_82481_);
    }
}

